/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.block;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.client.models.obj.callback.block.BlockCallback;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorRedstoneBlockEntity;
import com.mojang.math.Vector4f;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RSConnectorCallbacks
implements BlockCallback<Key> {
    public static final RSConnectorCallbacks INSTANCE = new RSConnectorCallbacks();
    private static final Key INVALID = new Key(IEEnums.IOSideConfig.INPUT, DyeColor.WHITE);

    @Override
    public Key extractKey(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, BlockEntity blockEntity) {
        if (!(blockEntity instanceof ConnectorRedstoneBlockEntity)) {
            return this.getDefaultKey();
        }
        ConnectorRedstoneBlockEntity connector = (ConnectorRedstoneBlockEntity)blockEntity;
        return new Key(connector.ioMode, connector.redstoneChannel);
    }

    @Override
    public Key getDefaultKey() {
        return INVALID;
    }

    @Override
    public boolean shouldRenderGroup(Key key, String group, RenderType layer) {
        if ("io_out".equals(group)) {
            return key.ioMode() == IEEnums.IOSideConfig.OUTPUT;
        }
        if ("io_in".equals(group)) {
            return key.ioMode() == IEEnums.IOSideConfig.INPUT;
        }
        return true;
    }

    @Override
    public Vector4f getRenderColor(Key key, String group, String material, ShaderCase shader, Vector4f original) {
        if ("coloured".equals(group)) {
            float[] rgb = key.channel().m_41068_();
            return new Vector4f(rgb[0], rgb[1], rgb[2], 1.0f);
        }
        return original;
    }

    public record Key(IEEnums.IOSideConfig ioMode, DyeColor channel) {
    }
}

